local prefabs =
{
"collapse_small",
"collapse_big",
}

local function MakeNightmareTool(data)

    --local bank = data.base 
    --local build = data.name 
    
    local assets=
    {
	Asset("ANIM", "anim/"..data.name..".zip"),
	Asset("ANIM", "anim/swap_"..data.name..".zip"),
	Asset("IMAGE", "images/inventoryimages/"..data.name..".tex"),
	Asset("ATLAS", "images/inventoryimages/"..data.name..".xml"),
    }
	
	local function onfinished(inst)
    inst:Remove()
	inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
	SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
--	owner.components.sanity:DoDelta( -20 )
	end

	local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_"..data.name, "swap_"..data.base)
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())	
	inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
	end

	local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())	
	inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
	end

    local function fn()
	    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
	
	anim:SetBank(data.base)
    anim:SetBuild(data.name)
    anim:PlayAnimation("idle")
    
	if data.sharp == true then
    inst:AddTag("sharp")
	end
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(data.damage)

    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(data.action)
    -------
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(data.uses)
    inst.components.finiteuses:SetUses(data.uses)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(data.action, 1)
    -------
	local base_finiteuses_OnUsedAsItem = inst.components.finiteuses.OnUsedAsItem
inst.components.finiteuses.OnUsedAsItem = function( self, action )
	base_finiteuses_OnUsedAsItem( self, action )
	
    	if action == data.action then
		if self.inst.components.inventoryitem and self.inst.components.inventoryitem.owner then
			local owner = self.inst.components.inventoryitem.owner
			owner.components.sanity:DoDelta( data.penalty )
			SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
			inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
		end
	end
end

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = data.name
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..data.name..".xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    
    inst.components.equippable:SetOnUnequip( onunequip)

    
    return inst
    end
        
    return Prefab( "common/inventory/"..data.name, fn, assets)
end


local data = {
			  {name="nightmareaxe", base="axe", action=ACTIONS.CHOP, uses=TUNING.AXE_USES*6, damage=TUNING.AXE_DAMAGE*1.1, sharp=true, penalty=-.20},
			  {name="nightmarehammer", base="hammer", action=ACTIONS.HAMMER, uses=TUNING.HAMMER_USES*2, damage=TUNING.HAMMER_DAMAGE*1.1, sharp=nil, penalty=-.40},
			  {name="nightmarepickaxe", base="pickaxe", action=ACTIONS.MINE, uses=TUNING.PICKAXE_USES*6, damage=TUNING.PICK_DAMAGE*1.1, sharp=true, penalty=-.30},
			  {name="nightmareshovel", base="shovel", action=ACTIONS.DIG, uses=TUNING.SHOVEL_USES*6, damage=TUNING.SHOVEL_DAMAGE*1.1, sharp=nil, penalty=-.50}
			 }

local ret = {}
for k,v in pairs(data) do
	table.insert(ret, MakeNightmareTool(v))
end


return unpack(ret) 
